/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;

public final class VWMergeType {
    private static final int MIN_MERGE_TYPE = 1;
    public static final int MERGE_TYPE_DEFAULT = 1;
    public static final int MERGE_TYPE_APPEND = 2;
    public static final int MERGE_TYPE_OVERRIDE = 3;
    public static final int MERGE_TYPE_OVERRIDE_ENTRY = 4;
    public static final int MERGE_TYPE_ADD = 5;
    public static final int MERGE_TYPE_APPEND_NO_DUP = 6;
    private static final int MAX_MERGE_TYPE = 6;
    private static String[] LocalizedStrings = new String[]{new VWString("vw.api.VWMergeTypeDefault", "Default").toString(), new VWString("vw.api.VWMergeTypeAppend", "Append").toString(), new VWString("vw.api.VWMergeTypeOverride", "Override").toString(), new VWString("vw.api.VWMergeTypeOverrideEntry", "OverrideEntry").toString(), new VWString("vw.api.VWMergeTypeAdd", "Add").toString(), new VWString("vw.api.VWMergeTypeAppendNoDup", "AppendNoDup").toString()};

    public static String _get_FILE_DATE() {
        return "$Date:   09 Sep 2008 14:10:36  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.18  $";
    }

    public static String getLocalizedString(int theMergeType) throws VWException {
        if (!VWMergeType.isValid(theMergeType)) {
            throw new VWException("vw.api.VWMergeTypeBadInteger", "Integer form of the merge type is invalid: {0}", String.valueOf(theMergeType));
        }
        return LocalizedStrings[theMergeType - 1];
    }

    public static boolean isValid(int theMergeType) {
        return theMergeType >= 1 && theMergeType <= 6;
    }

    protected static String typeToString(int mergeType) throws VWException {
        switch (mergeType) {
            case 1: {
                return "default";
            }
            case 2: {
                return "append";
            }
            case 3: {
                return "override";
            }
            case 4: {
                return "override_entry";
            }
            case 5: {
                return "add";
            }
            case 6: {
                return "AppendNoDup";
            }
        }
        throw new VWException("vw.api.VWMergeTypeBadInteger", "Integer form of the merge type is invalid: {0}", String.valueOf(mergeType));
    }

    protected static int stringToType(String mergeType) throws VWException {
        if (mergeType.equals("default")) {
            return 1;
        }
        if (mergeType.equals("append")) {
            return 2;
        }
        if (mergeType.equals("override")) {
            return 3;
        }
        if (mergeType.equals("override_entry")) {
            return 4;
        }
        if (mergeType.equals("add")) {
            return 5;
        }
        if (mergeType.equals("AppendNoDup")) {
            return 6;
        }
        throw new VWException("vw.api.VWMergeTypeBadString", "String form of the merge type is invalid: {0}", mergeType);
    }
}

